//
//  OPTextureManager.m
//  The Obfuscated Path
//
//  Created by ss2cire on 12/5/08.
//  Copyright 2008 GryphonClaw Software. All rights reserved.
//

#import "OPTextureManager.h"
#import <OpenGL/OpenGL.h>
#import <OpenGL/glu.h>

static OPTextureManager *textureManager;


@implementation OPTextureManager
- (id)init
{
	self = [super init];
	if(self != nil)
	{
		textures = [[NSMutableDictionary alloc] init];
	}
	return self;
}

- (void)dealloc
{
	[textures release];
	[super dealloc];
}

+ (OPTextureManager *)sharedManager
{
	if(textureManager == nil)
	{
		textureManager = [[OPTextureManager alloc] init];
	}
	return textureManager;
}

- (GLuint)textureWithName:(NSString *)name
{
	NSNumber *textureID = [textures objectForKey:name];
	NSString *subDirectory = @"Textures";
	GLuint textID = [textureID unsignedIntValue];
	if(textureID == NULL)//texture doesn't exist, so lets attempt to load it.
	{
		NSString *fullPath = [[NSBundle mainBundle] pathForResource:name ofType:@"png" inDirectory:subDirectory];
		textID = [self loadImageFromPath:fullPath fileName:name];
		if(textID != 0)
		{
			textureID = [NSNumber numberWithUnsignedInt:textID];
			[textures setObject:textureID forKey:name];
		}
	}
	return textID;
}

- (GLuint)loadImageFromPath:(NSString *)fullPath fileName:(NSString *)name
{
	if(![[NSFileManager defaultManager] fileExistsAtPath:fullPath] || fullPath == nil)
	{
		NSLog(@"The file \"%@\" at path %@ doesnt' exist.", name, fullPath);
		return 0;
	}
	GLuint textID;
	CGImageSourceRef source = CGImageSourceCreateWithURL((CFURLRef)[NSURL fileURLWithPath:fullPath], nil);
    CGImageRef image = CGImageSourceCreateImageAtIndex(source, 0, nil);
    
    int width = CGImageGetWidth(image);
    int height = CGImageGetHeight(image);
	
	void *data = calloc(width * height * 4, 1);
	
	CGColorSpaceRef colorSpace = CGColorSpaceCreateDeviceRGB();
    CGContextRef context = CGBitmapContextCreate(data, width, height, 8,	width * 4,
												 colorSpace, kCGImageAlphaPremultipliedLast);
    CGContextDrawImage(context, CGRectMake(0, 0, width, height), image);
	
	
	CGLContextObj aContext = CGLGetCurrentContext();
	if(aContext == NULL)
	{
		NSLog(@"you have a null context, what's going on?");
		return 0;
	}
	
	glGenTextures(1, &textID);
	glBindTexture(GL_TEXTURE_2D, textID);
	gluBuild2DMipmaps(GL_TEXTURE_2D, GL_RGBA, width, height, GL_RGBA, GL_UNSIGNED_BYTE, data);
	glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR_MIPMAP_LINEAR);
	glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR_MIPMAP_LINEAR);
	
	free(data);
	CFRelease(context);
	CFRelease(image);
	CFRelease(source);
	CFRelease(colorSpace);
	return textID;
}
@end
